/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.client;

import java.util.ArrayList;
import java.util.Objects;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ActiveChallengesOverlay {
    private static final int DISPLAY_TIME = 200;
    private static final int FADE_TIME = 40;
    private static int ticksRemaining = 0;
    private static boolean shouldShow = false;
    private static boolean notificationsEnabled = true;
    private static boolean isPermanentlyShown = false;

    public static void showActiveChallengesToast() {
        if (!notificationsEnabled) {
            return;
        }
        ticksRemaining = 200;
        shouldShow = true;
    }

    public static void toggleOverlay() {
        boolean bl = isPermanentlyShown = !isPermanentlyShown;
        if (isPermanentlyShown) {
            shouldShow = true;
            ticksRemaining = Integer.MAX_VALUE;
        } else {
            shouldShow = false;
            ticksRemaining = 0;
        }
    }

    public static void toggleNotifications() {
        notificationsEnabled = !notificationsEnabled;
    }

    public static boolean areNotificationsEnabled() {
        return notificationsEnabled;
    }

    public static void render(class_332 context, class_310 client) {
        if (!shouldShow || !isPermanentlyShown && ticksRemaining <= 0) {
            return;
        }
        ArrayList<Challenge> activeChalllenges = new ArrayList<Challenge>();
        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
            if (!challenge.isEnabled()) continue;
            activeChalllenges.add(challenge);
        }
        if (activeChalllenges.isEmpty()) {
            shouldShow = false;
            return;
        }
        int alpha = 255;
        if (!isPermanentlyShown && ticksRemaining < 40) {
            alpha = (int)((float)ticksRemaining / 40.0f * 255.0f);
        }
        int x = 5;
        int y = 5;
        int width = 200;
        Objects.requireNonNull(client.field_1772);
        int lineHeight = 9 + 2;
        context.method_25294(x, y, x + width, y + lineHeight + activeChalllenges.size() * lineHeight, (alpha << 24 | 0) & 0x7F000000);
        context.method_27535(client.field_1772, (class_2561)class_2561.method_43470((String)"Active Challenges:"), x + 5, y + 2, 0xFFFF55 | alpha << 24);
        y += lineHeight;
        for (Challenge challenge : activeChalllenges) {
            context.method_27535(client.field_1772, challenge.getName(), x + 5, y + 2, 0xFFFFFF | alpha << 24);
            y += lineHeight;
        }
        if (!isPermanentlyShown) {
            --ticksRemaining;
        }
    }
}

